#include <string.h>
#include <stdio.h>
#include "BufferedFile.h"

int main()
{
	BufferedFile TestFile("Test file", B_WRITE_ONLY|B_CREATE_FILE|B_ERASE_FILE, 25);
	if(TestFile.InitCheck() == B_NO_ERROR)
	{
		bool WrittenCorrectly = true;
		uint32 Counter;
		for(Counter = 0; Counter < 45; Counter++)
			if(TestFile.WriteNumber(&Counter,sizeof(Counter),1) != 1)
				WrittenCorrectly = false;
		uint16 Buffer[20];
		for(Counter = 0; Counter < 20; Counter++)
			Buffer[Counter] = Counter;
		if(TestFile.WriteNumber(Buffer,sizeof(*Buffer),20) != 20)
			WrittenCorrectly = false;
		if(TestFile.WriteString("Hello") != B_NO_ERROR)
			WrittenCorrectly = false;
		if(TestFile.WriteRaw("*Raw data*",11) != 11)
			WrittenCorrectly = false;		
		if(TestFile.FlushBuffer() != B_NO_ERROR)
			WrittenCorrectly = false;
		printf("File %s written correctly\n",WrittenCorrectly?"was":"was not");
	}
	else
		printf("File could not be opened for write! Error = %08X\n",(int)TestFile.InitCheck());
}
